/*
 * Decompiled with CFR 0.152.
 */
package com.james.tinkerscalibration.modifiers.armor;

import com.james.tinkerscalibration.TinkersCalibrationArmorModifiers;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.modules.technical.ArmorLevelModule;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

public class ArmorLifeInspireModifier
extends Modifier {
    private static final TinkerDataCapability.TinkerDataKey<Integer> LIFE = TConstruct.createKey((String)"life_armor");

    public ArmorLifeInspireModifier() {
        MinecraftForge.EVENT_BUS.addListener(ArmorLifeInspireModifier::onUpdateApply);
    }

    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        hookBuilder.addModule((HookProvider)new ArmorLevelModule(LIFE, false, null));
    }

    private static void onUpdateApply(LivingEvent.LivingTickEvent evt) {
        EquipmentContext context;
        LivingEntity living = evt.getEntity();
        if (!living.m_5833_() && (context = new EquipmentContext(living)).hasModifiableArmor() && !living.f_19853_.f_46443_ && living instanceof Player) {
            Player player = (Player)living;
            if (player.f_36079_ >= 1 && player.m_21223_() <= 4.0f && player.m_6084_()) {
                living.getCapability(TinkerDataCapability.CAPABILITY).ifPresent(holder -> {
                    int level = (Integer)holder.get(LIFE, (Object)0);
                    if (level > 0) {
                        IToolStackView patt4072$temp;
                        IToolStackView patt3461$temp;
                        IToolStackView patt2849$temp;
                        ToolStack tool;
                        IToolStackView patt2238$temp = context.getToolInSlot(EquipmentSlot.LEGS);
                        if (patt2238$temp instanceof ToolStack && (tool = (ToolStack)patt2238$temp).getModifierLevel(TinkersCalibrationArmorModifiers.lifeinspire.get()) > 0 && !tool.isBroken()) {
                            ToolDamageUtil.damageAnimated((IToolStackView)tool, (int)(level + 1), (LivingEntity)player);
                            player.m_6756_(-10 - level * 10);
                            player.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 20 * level, level - 1));
                        }
                        if ((patt2849$temp = context.getToolInSlot(EquipmentSlot.HEAD)) instanceof ToolStack && (tool = (ToolStack)patt2849$temp).getModifierLevel(TinkersCalibrationArmorModifiers.lifeinspire.get()) > 0 && !tool.isBroken()) {
                            ToolDamageUtil.damageAnimated((IToolStackView)tool, (int)(level + 1), (LivingEntity)player);
                            player.m_6756_(-10 - level * 10);
                            player.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 20 * level, level - 1));
                        }
                        if ((patt3461$temp = context.getToolInSlot(EquipmentSlot.CHEST)) instanceof ToolStack && (tool = (ToolStack)patt3461$temp).getModifierLevel(TinkersCalibrationArmorModifiers.lifeinspire.get()) > 0 && !tool.isBroken()) {
                            ToolDamageUtil.damageAnimated((IToolStackView)tool, (int)(level + 1), (LivingEntity)player);
                            player.m_6756_(-10 - level * 10);
                            player.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 20 * level, level - 1));
                        }
                        if ((patt4072$temp = context.getToolInSlot(EquipmentSlot.FEET)) instanceof ToolStack && (tool = (ToolStack)patt4072$temp).getModifierLevel(TinkersCalibrationArmorModifiers.lifeinspire.get()) > 0 && !tool.isBroken()) {
                            ToolDamageUtil.damageAnimated((IToolStackView)tool, (int)(level + 1), (LivingEntity)player);
                            player.m_6756_(-10 - level * 10);
                            player.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 20 * level, level - 1));
                        }
                    }
                });
            }
        }
    }
}

